//
//  GSVodPlayerTestViewController.m
//  PlayerSDKDemo
//
//  Created by 张俞 on 2023/10/27.
//  Copyright © 2023 Geensee. All rights reserved.
//

#import "GSVodPlayerTestViewController.h"
#import "UIView+GSSetRect.h"
#import "GSVodPlayerBar.h"
#import "GSMenu.h"
#import <GSCommonKit/GSCommonKit.h>
//#import "GSVodQueueController.h"
#import "GSVodChatView.h"
#import "GSItemBar.h"
#import "GSVodSwitchView.h"
#import "GSVodPlayerController+Notification.h"
#import "GSVodChatModel.h"

#define FASTSDK_COLOR16(value) [UIColor colorWithRed:((float)((value & 0xFF0000) >> 16))/255.0 green:((float)((value & 0xFF00) >> 8))/255.0 blue:((float)(value & 0xFF))/255.0 alpha:1.0]

@interface GSVodPlayerTestViewController ()<GSVodPlayerBarDelegate,GSDocViewDelegate,VodPlayDelegate>

@property (nonatomic, strong) VodPlayer *vodPlayer;
@property (nonatomic, strong) VodGLView *vodView;
@property (nonatomic, strong, nullable) dispatch_source_t requestTimer;
@property (nonatomic, assign) NSInteger index;
@property (nonatomic, strong) NSMutableArray * itemsArray;

@property (nonatomic, strong) NSMutableArray * vodViewArray;

@end

@implementation GSVodPlayerTestViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"播放界面";
    self.itemsArray = [[NSMutableArray alloc] init];
    self.vodViewArray = [[NSMutableArray alloc] init];
    
    self.view.backgroundColor = [UIColor whiteColor];
    self.vodPlayer = [GSVodManager sharedInstance].player;
    self.vodPlayer.cacheNum = 5;
    self.vodPlayer.delegate = self;
    self.index = 0;
    
    for (int index = 0; index < 6; index++) {
        [self createVodViewWithIndex:index];
    }
    [self requestDownItem];


}
-(void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event{
    if(self.requestTimer){
        dispatch_cancel(self.requestTimer);
        self.requestTimer = nil;
    }else{
        [self startRequestTimer];
    }
}

#pragma mark -- 销毁点播播放器
- (void)destroyVodPlayer{
    [self.vodPlayer stop];
}
- (void)requestDownItem{

    for (NSString * roomNumber in [self roomNumbers]) {
        GSConnectInfo *params = [GSConnectInfo new];
        params.domain = @"product.gensee.com";
        params.roomNumber = [self roomNumbers][self.index];
        params.watchPassword = @"";
        params.nickName = @"support";
        params.serviceType = GSBroadcastServiceTypeWebcast;
        params.oldVersion = NO;
        [[GSVodManager sharedInstance] request:params download:NO completion:^(downItem *item, GSVodWebaccessError type) {
            NSString *msg;
            switch (type) {
                case GSVodWebaccessSuccess:
                {
                    [self.itemsArray addObject:item];
                    if(self.itemsArray.count == [self roomNumbers].count){
                        [self startRequestTimer];
                    }
                    return;
                }
                    break;

                default:{
                    msg = [NSString stringWithFormat:@"错误类型:%lu",(unsigned long)type];
                }
                    break;
            }
            
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:msg delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
            [alert show];
        }];
    }
  
}

#pragma mark -VodPlayDelegate
//初始化VodPlayer代理
- (void)onInit:(int)result haveVideo:(BOOL)haveVideo duration:(int)duration docInfos:(NSDictionary *)docInfos
{
    NSLog(@"[VodPlayer] onInit :%d duration %d , %@",result,duration,_vodPlayer.playItem.strDownloadID);
//    [self createPlayer];
    
}
- (void)onVideoStart{
  
}
- (NSArray *)roomNumbers{
    
    return [@"16931054,72453270,69461059,07018786,10134497,64238623" componentsSeparatedByString:@","];


}
- (void)createPlayer{
//    [self.vodPlayer stop];
    self.index ++;
    if(self.index >= self.itemsArray.count){
        self.index = 0;
    }
//    [self createVodView];
    self.vodPlayer.mVideoView = self.vodViewArray[self.index];
    self.vodPlayer.playItem = self.itemsArray[self.index];
    [self.vodPlayer OnlinePlay:YES audioOnly:NO];
}
- (void)startRequestTimer {
    dispatch_queue_t queue = dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
    self.requestTimer = dispatch_source_create(DISPATCH_SOURCE_TYPE_TIMER, 0, 0, queue);
    //开始时间
    dispatch_time_t start = dispatch_time(DISPATCH_TIME_NOW, 0 * NSEC_PER_SEC);
    //间隔时间
    uint64_t interval = 1 * NSEC_PER_SEC;
    dispatch_source_set_timer(self.requestTimer, start, interval, 0);
    __weak typeof(self) weakSelf = self;
    dispatch_source_set_event_handler(self.requestTimer, ^{
        __strong typeof(weakSelf) strongSelf = weakSelf;
        dispatch_async(dispatch_get_main_queue(), ^{
            strongSelf.title = [NSString stringWithFormat:@"第%ld个点播视频",strongSelf.index];
            [strongSelf createPlayer];
        });
    });
    dispatch_resume(self.requestTimer);
}
- (void)createVodView{
    if (self.vodView) {
        [self.vodView removeFromSuperview];
        self.vodView = nil;
    }
    self.vodView = [[VodGLView alloc] initWithFrame:CGRectMake(0, 200, Width, ceil(Width*9/16)) renderMode:GSVideoRenderOpenGL];
    self.vodView.backgroundColor = [UIColor blackColor];
    self.vodView.contentMode = UIViewContentModeScaleAspectFit;
    
    [self.view addSubview:self.vodView];
}
- (void)createVodViewWithIndex:(NSInteger)index{

    CGFloat viewWidth = Width /2;
    
    VodGLView * vodView = [[VodGLView alloc] initWithFrame:CGRectMake(((index)%2) * viewWidth, 50+((index)/2)*viewWidth, viewWidth, viewWidth) renderMode:GSVideoRenderOpenGL];
    vodView.backgroundColor = [UIColor blackColor];
    vodView.contentMode = UIViewContentModeScaleAspectFit;
    [self.view addSubview:vodView];

    [self.vodViewArray addObject:vodView];
}

@end
